/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.contents.Contents;

public final class ParagliderUtils {
    private ParagliderUtils() {
    }

    public static void giveItem(PlayerEntity player, ItemStack stack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        while (!stack.func_190926_b()) {
            int slot = player.field_71071_by.func_70432_d(stack);
            if (slot == -1) {
                slot = player.field_71071_by.func_70447_i();
            }
            if (slot == -1) {
                while (!stack.func_190926_b()) {
                    ItemEntity itemEntity = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226283_e_(0.5), player.func_226281_cx_(), stack.func_77979_a(stack.func_77976_d()));
                    itemEntity.func_174867_a(40);
                    itemEntity.func_213293_j(0.0, 0.0, 0.0);
                    player.field_70170_p.func_217376_c((Entity)itemEntity);
                }
                break;
            }
            int count = stack.func_77976_d() - player.field_71071_by.func_70301_a(slot).func_190916_E();
            if (!player.field_71071_by.func_191971_c(slot, stack.func_77979_a(count))) continue;
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-2, slot, player.field_71071_by.func_70301_a(slot)));
        }
    }

    public static boolean takeHeartContainers(PlayerEntity player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (m.getHeartContainers() < quantity) {
            return false;
        }
        if (!simulate && !player.field_70170_p.field_72995_K) {
            m.setHeartContainers(m.getHeartContainers() - quantity);
        }
        return true;
    }

    public static boolean takeStaminaVessels(PlayerEntity player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (m.getStaminaVessels() < quantity) {
            return false;
        }
        if (!simulate && !player.field_70170_p.field_72995_K) {
            m.setStaminaVessels(m.getStaminaVessels() - quantity);
        }
        return true;
    }

    public static boolean takeEssences(PlayerEntity player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (m.getEssence() < quantity) {
            return false;
        }
        if (!simulate && !player.field_70170_p.field_72995_K) {
            m.setEssence(m.getEssence() - quantity);
        }
        return true;
    }

    public static boolean giveHeartContainers(PlayerEntity player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (ModCfg.maxHeartContainers() - m.getHeartContainers() < quantity) {
            return false;
        }
        if (!simulate && !player.field_70170_p.field_72995_K) {
            m.setHeartContainers(m.getHeartContainers() + quantity);
            player.func_70606_j(player.func_110138_aP() + (float)quantity);
            if (effect) {
                ParagliderUtils.spawnParticle(player, (IParticleData)ParticleTypes.field_197633_z, 5 + 5 * quantity);
            }
        }
        return true;
    }

    public static boolean giveStaminaVessels(PlayerEntity player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (ModCfg.maxStaminaVessels() - m.getStaminaVessels() < quantity) {
            return false;
        }
        if (!simulate && !player.field_70170_p.field_72995_K) {
            m.setStaminaVessels(m.getStaminaVessels() + quantity);
            m.setStamina(m.getMaxStamina());
            if (effect) {
                ParagliderUtils.spawnParticle(player, (IParticleData)ParticleTypes.field_197632_y, 7 + 7 * quantity);
            }
        }
        return true;
    }

    public static boolean giveEssences(PlayerEntity player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (Integer.MAX_VALUE - m.getEssence() < quantity) {
            return false;
        }
        if (!simulate && !player.field_70170_p.field_72995_K) {
            m.setEssence(m.getEssence() + quantity);
        }
        return true;
    }

    private static void spawnParticle(PlayerEntity player, IParticleData particle, int count) {
        ServerWorld world;
        ServerWorld serverWorld = world = player.field_70170_p instanceof ServerWorld ? (ServerWorld)player.field_70170_p : null;
        if (world == null) {
            return;
        }
        world.func_195598_a(particle, player.func_226277_ct_(), player.func_226283_e_(0.5), player.func_226281_cx_(), count, 1.0, 2.0, 1.0, 0.0);
    }

    @Nullable
    public static Item getAppropriateVessel() {
        return ModCfg.enableHeartContainers() ? (Item)Contents.HEART_CONTAINER.get() : (ModCfg.enableSpiritOrbGens() ? (Item)Contents.SPIRIT_ORB.get() : null);
    }
}

